/**========================================================================
 *                           Home Page Banner Slider
 *========================================================================**/

const homeSwiperTop = new Swiper(".hero-slider", {
  loop: true,
  spaceBetween: 16,
  allowTouchMove: true,
  effect: "fade",
  speed:1000,
  autoplay: {
    delay: 7000,
  },
  pagination: {
    clickable: true,
    el: ".hero-slider-pagination",
  },
});

/*================================ Description Image Slider  ==============================*/

const descriptionSlider = new Swiper(".description-section-slider", {
  spaceBetween: 16,
  allowTouchMove: true,
  loop: true,
  autoplay: {
    delay: 5000,
  },
});

/*================================ Link Image Slider  ==============================*/

const linkImageSlider = new Swiper(".link-images-slider", {
  slidesPerView: "auto",
  loop: true,
  spaceBetween: 16,
  breakpoints: {
    0: {
      slidesPerView: "auto",
      effect: "coverflow",
      centeredSlides: true,
      coverflowEffect: {
        rotate: 0,
        stretch: 0,
        depth: 20,
        modifier: 0,
        slideShadows: false,
      },
    },
    768: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
});

/*================================ Expert Slider ==============================*/

const expertsCarousel = new Swiper(".experts-carousel", {
  slidesPerView: "auto",
  loop: true,
  spaceBetween: 16,
  slidesPerView: "auto",
  effect: "coverflow",
  centeredSlides: true,
  coverflowEffect: {
    rotate: 0,
    stretch: 0,
    depth: 20,
    modifier: 0,
    slideShadows: false,
  },
  breakpoints: {
    768: {
      centeredSlides: false,
      slidesPerView: 2,
    },
    1024: {
      centeredSlides: false,
      slidesPerView: 3,
    },
    1340: {
      centeredSlides: false,
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 5000,
  },
  navigation: {
    nextEl: ".experts-slider-next",
    prevEl: ".experts-slider-prev",
  },
});
/*============================== Service Slider ===========================*/

const servicesSlider = new Swiper(".services-slider", {
  slidesPerView: 1,
  spaceBetween: 16,
  loop: true,
  breakpoints: {
    600: {
      slidesPerView: 2,
    },
    900: {
      slidesPerView: 3,
    },
    1200: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".services-slider-next",
    prevEl: ".services-slider-prev",
  },
});

/*============================== Service Slider ===========================*/

const categoriesSlider = new Swiper(".categories-slider", {
  slidesPerView: 1,
  spaceBetween: 16,
  loop: true,
  breakpoints: {
    600: {
      slidesPerView: 2,
    },
    900: {
      slidesPerView: 3,
    },
    1200: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".categories-slider-next",
    prevEl: ".categories-slider-prev",
  },
});

/*============================== Project Slider ===========================*/

const projectsSlider = new Swiper(".projects-slider", {
  slidesPerView: 1,
  spaceBetween: 16,
  loop: true,
  breakpoints: {
    600: {
      slidesPerView: 2,
    },
    900: {
      slidesPerView: 3,
    },
    1200: {
      slidesPerView: 4,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".projects-slider-next",
    prevEl: ".projects-slider-prev",
  },
});

/*============================== Customer Comments Slider ===========================*/

const customerComments = new Swiper(".customer-comments-slider", {
  slidesPerView: 1,
  spaceBetween: 16,
  loop: true,
  breakpoints: {
    768: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 20000,
  },
  navigation: {
    nextEl: ".customer-comments-slider-next",
    prevEl: ".customer-comments-slider-prev",
  },
});

/*======================= Logos Slider =======================*/

const partnersSlider = new Swiper(".logos-slider", {
  slidesPerView: 2,
  loop: true,
  spaceBetween: 16,
  breakpoints: {
    550: { slidesPerView: 2 },
    768: { slidesPerView: 3 },
    992: { slidesPerView: 5 },
    1200: { slidesPerView: 6, spaceBetween: 0 },
  },
  speed: 4000,
  autoplay: {
    delay: 0,
    disableOnInteraction: false,
  },
  allowTouchMove: true,
  freeMode: {
    enabled: true,
    momentum: false,
    sticky: false,
  },
  on: {
    touchEnd: (swiper) => {
      swiper.autoplay.start();
    },
  },
});

partnersSlider.on("transitionEnd", () => {
  const slides = partnersSlider.slides;
  const middleIndex = Math.floor(partnersSlider.activeIndex + partnersSlider.params.slidesPerView / 2);

  slides.forEach((slide) => slide.classList.remove("active"));

  if (slides[middleIndex]) {
    slides[middleIndex].classList.add("active");
  }
});


/*============================== Blog Slider ===========================*/

const blogSlider = new Swiper(".blog-slider", {
  slidesPerView: 1,
  spaceBetween: 16,
  loop: true,
  breakpoints: {
    768: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".blog-slider-next",
    prevEl: ".blog-slider-prev",
  },
});

/*============================== Project Slider ===========================*/

const projectSlider = new Swiper(".project-slider", {
  slidesPerView: 1,
  spaceBetween: 0,
  loop: true,
  breakpoints: {
    768: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 8000,
  },
  navigation: {
    nextEl: ".project-slider-next",
    prevEl: ".project-slider-prev",
  },
});

/*============================== Image Gallery Slider ===========================*/

const imageGallery = new Swiper(".images-gallery-slider", {
  slidesPerView: 1,
  spaceBetween: 16,
  loop: true,
  breakpoints: {
    768: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  autoplay: {
    pauseOnMouseEnter: true,
    delay: 20000,
  },
  navigation: {
    nextEl: ".images-gallery-slider-next",
    prevEl: ".images-gallery-slider-prev",
  },
});

/*================================ Media Slider ==============================*/

const mediaSlider = new Swiper(".media-slider", {
  loop: true,
  effect: "fade",
  allowTouchMove: false,
  autoplay: {
    delay: 3000,
  },
});

/*================================ Product Slider ==============================*/

const productSliderThumbnail = new Swiper(".product-slider-thumbnail", {
  spaceBetween: 8,
  slidesPerView: 4,
  freeMode: true,
  watchSlidesProgress: true,
});
const productSlider = new Swiper(".product-image-slider", {
  spaceBetween: 8,
  navigation: {
    nextEl: ".product-slider-next",
    prevEl: ".product-slider-prev",
  },
  thumbs: {
    swiper: productSliderThumbnail,
  },
});